<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Database Utilities</title>
    <link rel="stylesheet" type="text/css" href="app_assets/css/bootstrap.min.css">
</head>
<body>
<?php
/**
 * @var array $sponsor
 */
require('public/views/partials/navbar.php');
?>


<?php if (isset($_SESSION['missingFields'])): ?>
    <div class="alert alert-danger" role="alert">
        The following fields were missing from the record you submitted: <?= implode(', ', $_SESSION['missingFields']); ?>
    </div>
    <?php unset($_SESSION['missingFields']); ?>
<?php endif; ?>

<?php if (isset($success)): ?>
    <div class="alert alert-success" role="alert">
        <?= $success; ?>
    </div>
<?php endif; ?>

<div class="container d-flex flex-column align-items-center mt-5">
    <h1>Edit Record</h1>
    <br>
    <form method="post" class="w-100 justify-content-center" action="sponsor_utilities/update?id=<?= $sponsor['id'] ?>">
        <?php foreach ($sponsor as $key => $value): ?>
            <div class="mb-3 d-flex flex-column align-items-center">
                <label for="<?= $key; ?>" class="form-label"><?= ucfirst($key); ?></label>
                <input type="text" class="form-control w-50" id="<?= $key; ?>" name="<?= $key; ?>" value="<?= $value; ?>">
            </div>
        <?php endforeach; ?>
        <input type="hidden" name="update_sponsor" value="1">
        <div class="d-flex justify-content-center mb-5">
            <button type="submit" class="btn btn-primary">Submit</button>
        </div>
    </form>



</div>
<script src=app_assets/js/bootstrap.bundle.min.js></script>
</body>
</html>