<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title>Index</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            overflow: hidden;
        }
        iframe {
            display: block;
            width: 1080px;
            height: 100%;
            margin: 0;
        }
        #slide-container {
            height: 1840px;
            width: 100%;
            top: 0;
            overflow: hidden;
        }

        #feedback {
            display: block;
            position: fixed;
            top: 10%;
            left: 50%;
            width: 75%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.5);
            color: white;
            padding: 20px;
            border-radius: 10px;
            font-size: 2em;
            font-family: "Open Sans ExtraBold", sans-serif;
            z-index: 1;
            text-align: center;
            opacity: 0;
            animation: fadeinout 5s linear;
        }

        @keyframes fadeinout {
            0% { opacity: 0; }
            50% { opacity: 1; }
            100% { opacity: 0; }
        }
    </style>
</head>

<body style="background-color: black">

<div id="slide-container">


<div id="feedback">
    Touch the screen to return to the index
</div>

<div style="position: relative; width: 67.5rem; height: 116.875rem;">
    <?php
    if (empty($_SESSION['playlist'])) {
        echo "<script>document.getElementById('feedback').innerHTML = 'No news available. Touch the screen to return to the index.';</script>";
    } else {
        $i = $_SESSION['current_playlist_index'];
        echo $_SESSION['playlist'][$i]['link'];
        // force count of zero if greater than 0 so that only the first item is displayed
        // ToDo: This is a temporary fix to display only the first item in the playlist
        if ($_SESSION['current_playlist_index'] > 0) {
            $_SESSION['current_playlist_index'] = 0;
        }
        $_SESSION['current_playlist_index'] = 0;
    }
    ?>
    <!-- suppress HtmlUnknownTarget -->
    <a href="/index">
        <div id="overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 2;"></div>
    </a>
</div>

</div>

<!-- display 'touch the screen' feedback and reload page after x duration -->
<script>
    // get the iframe and feedback elements
    let iframe = document.querySelector('iframe');
    let feedback = document.getElementById('feedback');

    // when the iframe has finished loading
    iframe.onload = function() {
        // show the feedback div
        if (feedback) {
            feedback.style.animation = 'fadeinout 5s linear';
        }
    };

    // reload page after x duration
    let duration = <?= $_SESSION['playlist'][0]['play_for'] ?? 5; ?> // Default to 5 seconds if not set>;
    setTimeout(function() {
        window.location.href = '/index';
    }, duration * 1000); // Convert to milliseconds
</script>

</body>
</html>