<?php
$isEdit = isset($sponsor);
$title = $isEdit ? 'Edit Sponsor' : 'Add New Sponsor';
$formAction = $isEdit ? "/admin/edit/{$sponsor['id']}" : '/admin/create';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?> - Home Hardware PWA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background-color: #343a40;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.75);
            padding: 0.75rem 1rem;
            margin: 0.25rem 0;
            border-radius: 0.25rem;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
        }
        .sidebar .nav-link i {
            margin-right: 0.5rem;
            width: 1.25rem;
            text-align: center;
        }
        .preview-image {
            max-width: 200px;
            max-height: 150px;
            margin-top: 10px;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            padding: 5px;
        }
        .file-input-label {
            cursor: pointer;
            display: inline-block;
            padding: 6px 12px;
            background-color: #f8f9fa;
            border: 1px solid #ced4da;
            border-radius: 4px;
        }
        .file-input-label:hover {
            background-color: #e9ecef;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="d-flex flex-column p-3">
                    <a href="/admin" class="d-flex align-items-center mb-3 mb-md-0 me-md-auto text-white text-decoration-none">
                        <span class="fs-4">Admin Panel</span>
                    </a>
                    <hr>
                    <ul class="nav nav-pills flex-column mb-auto">
                        <li class="nav-item">
                            <a href="/admin" class="nav-link">
                                <i class="bi bi-grid"></i> Dashboard
                            </a>
                        </li>
                        <li>
                            <a href="/admin/create" class="nav-link active">
                                <i class="bi bi-plus-circle"></i> Add New Sponsor
                            </a>
                        </li>
                        <li>
                            <a href="/admin/logout" class="nav-link text-danger">
                                <i class="bi bi-box-arrow-right"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><?php echo $title; ?></h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="/admin" class="btn btn-sm btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <?php if (isset($error)): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo htmlspecialchars($error); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="<?php echo $formAction; ?>" enctype="multipart/form-data">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="name" class="form-label">Sponsor Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" required 
                                           value="<?php echo htmlspecialchars($sponsor['name'] ?? ''); ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="display_order" class="form-label">Display Order</label>
                                    <input type="number" class="form-control" id="display_order" name="display_order" 
                                           value="<?php echo $sponsor['display_order'] ?? '0'; ?>">
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                               value="1" <?php echo (isset($sponsor['is_active']) && $sponsor['is_active']) ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="is_active">Active</label>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Logo/Image <small class="text-muted">(Recommended: 200x200px, PNG with transparent background)</small></label>
                                    <div class="mb-2">
                                        <?php if (!empty($sponsor['image_path'])): ?>
                                            <img src="<?php echo htmlspecialchars($sponsor['image_path']); ?>" alt="Current logo" class="preview-image" id="logoPreview">
                                        <?php else: ?>
                                            <img src="" alt="No image selected" class="preview-image d-none" id="logoPreview">
                                        <?php endif; ?>
                                    </div>
                                    <label for="image" class="file-input-label w-100">
                                        <i class="bi bi-upload"></i> Choose Image
                                        <input type="file" class="d-none" id="image" name="image" accept="image/*" onchange="previewImage(this, 'logoPreview')">
                                    </label>
                                    <div class="form-text">Leave empty to keep current image</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Video <small class="text-muted">(MP4, WebM, or OGG)</small></label>
                                    <div class="mb-2">
                                        <?php if (!empty($sponsor['video_path'])): ?>
                                            <video width="200" controls class="preview-video">
                                                <source src="<?php echo htmlspecialchars($sponsor['video_path']); ?>" type="video/mp4">
                                                Your browser does not support the video tag.
                                            </video>
                                            <div class="form-text">Current video: <?php echo basename($sponsor['video_path']); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <label for="video" class="file-input-label w-100">
                                        <i class="bi bi-upload"></i> Choose Video
                                        <input type="file" class="d-none" id="video" name="video" accept="video/*">
                                    </label>
                                    <div class="form-text">Leave empty to keep current video</div>
                                </div>
                            </div>

                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="/admin" class="btn btn-outline-secondary me-md-2">Cancel</a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save"></i> <?php echo $isEdit ? 'Update' : 'Create'; ?> Sponsor
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            const file = input.files[0];
            
            if (file) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                }
                
                reader.readAsDataURL(file);
            } else {
                preview.src = '#';
                preview.classList.add('d-none');
            }
        }

        // Show preview for existing image on page load
        document.addEventListener('DOMContentLoaded', function() {
            const preview = document.getElementById('logoPreview');
            if (preview && !preview.src) {
                preview.classList.add('d-none');
            }
        });
    </script>
</body>
</html>
