<?php

// Database migration to add is_active column to sponsors table
$dbPath = __DIR__ . '/../../db/sponsors.db';

try {
    // Connect to the database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if the column exists
    $stmt = $db->query("PRAGMA table_info(sponsors)");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $columnExists = false;
    foreach ($columns as $column) {
        if ($column['name'] === 'is_active') {
            $columnExists = true;
            break;
        }
    }
    
    // Add the column if it doesn't exist
    if (!$columnExists) {
        $db->exec("ALTER TABLE sponsors ADD COLUMN is_active INTEGER DEFAULT 1");
        echo "Successfully added is_active column to sponsors table.\n";
    } else {
        echo "is_active column already exists in sponsors table.\n";
    }
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage() . "\n");
}
