<?php

$dbPath = __DIR__ . '/sponsors.db';

try {
    // Connect to the database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if table exists
    $tables = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='sponsors'")->fetchAll();
    
    if (empty($tables)) {
        die("The 'sponsors' table does not exist in the database.\n");
    }
    
    // Get table info
    $columns = $db->query("PRAGMA table_info(sponsors)")->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Sponsors table columns:\n";
    foreach ($columns as $column) {
        echo "- {$column['name']} ({$column['type']}) " . 
             ($column['notnull'] ? 'NOT NULL ' : '') . 
             ($column['dflt_value'] !== null ? "DEFAULT {$column['dflt_value']} " : '') . 
             ($column['pk'] ? 'PRIMARY KEY' : '') . "\n";
    }
    
    // Try to query the table
    try {
        $result = $db->query('SELECT * FROM sponsors LIMIT 1');
        echo "\nSuccessfully queried sponsors table.\n";
    } catch (PDOException $e) {
        echo "\nError querying sponsors table: " . $e->getMessage() . "\n";
    }
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage() . "\n");
}
