<?php
namespace Controllers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class SendMailController
{
    private PHPMailer $mail;
    private EmailController $emailController;

    public function __construct(EmailController $emailController)
    {
        $this->mail = new PHPMailer();
        $this->setupMailer();
        $this->emailController = $emailController;
    }

    private function setupMailer(): void
    {
        $this->mail->SMTPDebug = 0;
        $this->mail->isSMTP();
        $this->mail->Host = 'smtp.livemail.co.uk';
        $this->mail->SMTPAuth = true;
        $this->mail->Username = 'inforequest@time-cdn.co.uk';
        $this->mail->Password = 'T1m3M3d1a';
        $this->mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $this->mail->Port = 587;
        $this->mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ];
        $this->mail->setFrom('inforequest@time-cdn.co.uk', 'Info Request');
    }

    /**
     * @throws Exception
     */
    public function sendEmail(array $mailFieldValues): void
    {
        $data = [];
        try {
            $this->buildEmail($mailFieldValues);
            $this->mail->send();
            $message = "Email sent successfully!";
        } catch (Exception $e) {
            $message = "Failed to send email!";
        }
        $data['returnString'] = $mailFieldValues['returnString'];
        $data['sent'] = $message;
        $this->emailController->renderView('public/views/mail_result.view.php', $data);
    }

    private function buildEmail(array $mailFieldValues): void
    {
        $this->mail->addAddress($mailFieldValues['recipientEmail']);
        $this->mail->addCC('admin@time-cdn.co.uk');
        $this->mail->addBCC('vince.macrae@gmail.com');
        if (!is_numeric($mailFieldValues['requestPOC'])) {
            $this->mail->addReplyTo($mailFieldValues['requestPOC']);
        }
        $this->mail->isHTML();
        $this->mail->Subject = $mailFieldValues['emailType'] === 'store' ? 'Trade Connect Kiosk - Contact Request' : 'Information Request for ' . $mailFieldValues['sponsorName'];
        $this->mail->Body = $this->buildMailBody($mailFieldValues);
        $this->mail->AltBody = 'Information request for ' . $mailFieldValues['recipientEmail'];
    }

    private function buildMailBody(array $mailFieldValues): string
    {
        $mailBody = file_get_contents('resources/inforequesthead.txt');
        $mailBody .= '<p>You have received an enquiry from the information kiosk located at: ' . $mailFieldValues['sendingLocation'] . '</p>';
        $mailBody .= '<p>The point of contact requesting information is: ' . $mailFieldValues['requestPOC'] . '</p>';
        if (!empty($mailFieldValues['requestMessage'])) {
            $mailBody .= '<p>Additional details are: ' . $mailFieldValues['requestMessage'] . '</p>';
        }
        $mailBody .= file_get_contents('resources/inforequestfoot.txt');
        return $mailBody;
    }
}