<?php

namespace Controllers;

require_once 'vendor/autoload.php';
require_once 'vendor/jeroendesloovere\vcard\src\VCard.php';
require_once 'lib/qr_lib/full/qrlib.php';

use PDO;
use App\SQLiteConnection;
use Jeroendesloovere\VCard\VCard;
use QRcode;

class QRController {
    private PDO $pdo;

    public function __construct() {
        $this->pdo = (new SQLiteConnection())->getPDO();
    }

    public function customErrorHandler($errno, $errstr, $errfile, $errline): void
    {
        $logFilePath = 'logs/error.log';
        $errorMessage = "Error [$errno] on line $errline in file $errfile: $errstr\n";
        file_put_contents($logFilePath, $errorMessage, FILE_APPEND);
    }

    private function createQR($sponsor): void
    {
        set_error_handler([$this, 'customErrorHandler']);

        $vcard = new VCard();
        $vcard->addCompany($sponsor['business_name']);
        $vcard->addEmail($sponsor['email']);
        $vcard->addPhoneNumber($sponsor['phone'], 'PREF;WORK');
        $vcard->addPhoneNumber($sponsor['mobile'], 'CELL');
        $vcard->addAddress($sponsor['address_1'], $sponsor['address_2'], $sponsor['street'], $sponsor['city'], $sponsor['county'], $sponsor['postal_code'], NULL);
        $vcard->addURL($sponsor['url']);

        $vcardContents = $vcard->getOutput();
        $filePath = 'public/sponsor_assets/qrs/';
        $fileName = 'qr-'. $sponsor['contract'] . '.png';
        $pngAbsoluteFilePath = $filePath.$fileName;

        if (!file_exists($pngAbsoluteFilePath)) {
            QRcode::png($vcardContents, $pngAbsoluteFilePath);
            echo 'File ' . $fileName . ' generated!';
        } else {
            echo 'QR Code ' . $fileName . ' already generated!';
        }
        echo '<hr />';

        restore_error_handler();
    }

    private function getSponsors($id = null) {
        $sql = "SELECT * FROM sponsors";
        if($id) {
            $sql .= " WHERE id = " . $id;
        }
        $sponsors = $this->pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

        if (empty($sponsors)) {
            exit('Sponsor or sponsors not found');
        }

        return $sponsors;
    }

    public function handleRequest(): void
    {
        $id = isset($_GET['id']) ? $_GET['id'] : null;
        $sponsors = $this->getSponsors($id);

        foreach ($sponsors as $sponsor) {
            $this->createQR($sponsor);
        }
    }
}

$controller = new QRController();
$controller->handleRequest();