<?php
namespace Controllers;

class EmailController
{
    public function __construct($pdo)
    {
        $this->pdo = $pdo;
    }

    public function handleRequest(array $params): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            $this->handleGetRequest($params);
        } elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->handlePostRequest($params);
        }
    }

    private function handleGetRequest(array $params): void
    {
        $emailType = $params['emailType'] ?? '';
        $sponsorId = $params['sponsorId'] ?? null;
        $returnString = $emailType === 'store' ? 'index' : '/select_sponsor?id=' . $sponsorId;

        // Pass the parameters to the view
        $this->renderView('public/views/email.view.php', [
            'emailType' => $emailType,
            'sponsorId' => $sponsorId,
            'returnString' => $returnString
        ]);
    }

    private function handlePostRequest(array $params): void
    {
        $errors = $this->validateForm($params['requestPOC'], $params['agreed'] ?? null);

        if (!empty($errors)) {
            $this->renderView('public/views/email.view.php', [
                'errors' => $errors,
                'emailType' => $params['emailType'],
                'sponsorId' => $params['sponsorId'] ?? null,
                'returnString' => $params['returnString']
            ]);
            return;
        }

        $emailValues = [
            'requestPOC' => $params['requestPOC'],
            'requestMessage' => $params['requestMessage'],
            'returnString' => $params['returnString'],
            'emailType' => $params['emailType'],
            'sponsorId' => $params['sponsorId'] ?? null
        ];

        $confirmMailController = new ConfirmMailController($emailValues, $this);
        $confirmMailController->startProcessing();
    }

    private function validateForm($requestPOC, $agreed): array
    {
        $errors = [];

        if (!is_null($requestPOC)) {
            $checkEmail = $this->validateContactMethod($requestPOC);
            if ($checkEmail === "Invalid email format") {
                $errors['contactError'] = $checkEmail;
            }
        }

        if (!isset($agreed)) {
            $errors['agreementError'] = 'Agreement Not Checked';
        }

        return $errors;
    }

    private function validateContactMethod($str): string
    {
        if (!is_numeric($str)) {
            $str = $this->testInput($str);
            if (!filter_var($str, FILTER_VALIDATE_EMAIL)) {
                return "Invalid email format";
            }
        }
        return $str;
    }

    private function testInput($str): string
    {
        $data = trim($str);
        $data = stripslashes($data);
        return htmlspecialchars($data);
    }

    public function renderView(string $view, array $data = []): void
    {
        extract($data);
        require $view;
    }
}