<?php

namespace Utilities;

use Exception;

class ConfigSettings
{
    private string $configFilePath;

    public function __construct($configFilePath = 'public/config/site.cfg')
    {
        $this->configFilePath = $configFilePath;
    }

    public function getSettings(): array
    {
        return parse_ini_file($this->configFilePath);
    }

    public function updateSettings(array $newSettings): bool
    {
        $content = '';
        foreach ($newSettings as $key => $value) {
            $content .= "$key = \"$value\"\n";
        }

        try {
            file_put_contents($this->configFilePath, $content);
            return true;
        } catch (Exception $e) {
            return false;
        }
    }
}