<?php
/**
 * Application Routes
 * 
 * This file defines all the routes for the application.
 */

// Load Composer's autoloader
require 'vendor/autoload.php';

// Include path helper
require 'path_helper.php';

// Include configuration
$config = [];
if (file_exists('config.php')) {
    $config = require 'config.php';
}

// Create router instance
$router = new AltoRouter();

// Set the base path - use the one from config or calculate it
$basePath = $config['basePath'] ?? '';
if (empty($basePath)) {
    // Auto-detect base path if not set in config
    $scriptName = $_SERVER['SCRIPT_NAME'];
    $basePath = str_replace('index.php', '', $scriptName);
}

// Ensure base path starts with a slash
$basePath = '/' . ltrim($basePath, '/');

// Set the base path for the router
$router->setBasePath($basePath);

// Include controllers
require 'controllers/AdminController.php';
require 'controllers/ViewsController.php';

// Map routes
$router->map('GET', '/', 'Controllers\ViewsController@viewIndex', 'home');
$router->map('GET', '/index', 'ViewsController@viewIndex', 'index');

/* Email routes */
$router->map('GET|POST', '/email', 'EmailController@handleRequest', 'email');
$router->map('POST', '/sendmail', 'ConfirmMailController@sendConfirmedEmail', 'sendmail');
$router->map('GET', '/privacy_policy', 'PrivacyPolicyController@show', 'privacy_policy');
$router->map('GET', '/mailresult', 'MailResultController@show', 'mail_result');

/* Sponsors routes */
$router->map('GET', '/sponsors', 'SponsorsController@showAllSponsors', 'sponsors');
$router->map('GET', '/select_sponsor', 'SponsorsController@showSingleSponsor', 'select_sponsor');
$router->map('GET', '/sponsor_qr', 'SponsorsController@showSponsorQR', 'sponsor_qr');
$router->map('GET', '/createqrs', 'QRController@createQrs', 'create_qrs');
$router->map('GET', '/showvideo', 'ViewsController@showVideo', 'show_video');

/* News routes */
$router->map('GET', '/news', 'NewsController@showNews', 'news');

/* Brochure routes */
$router->map('GET', '/brochures', 'BrochureController@showBrochures', 'brochures');

/* Idle screen routes */
$router->map('GET', '/idle', 'IdleController@showIdleScreen', 'idle');

/* Content download routes */
$router->map('GET', '/download-content', 'ContentDownloaderController@downloadContent', 'download_content');

/* Utility routes */

// Utilities Home
$router->map('GET', '/utilities', 'SystemUtilitiesController@home', 'utilities');
// PHPInfo
$router->map('GET', '/phpinfo', 'SystemUtilitiesController@phpInfo', 'phpinfo');
//Playlist utilities
$router->map('GET|POST', '/playlist_utilities', 'PlaylistUtilitiesController@handleRequest', 'playlist_utilities');
// Configuration utilities
$router->map('GET|POST', '/configure', 'ConfigureAppController@handleRequest', 'configure');
// Database utilities
$router->map('GET', '/database_utilities', 'DatabaseUtilitiesController@index', 'database_utilities');
$router->map('GET', '/database_utilities/edit', 'DatabaseUtilitiesController@edit', 'database_utilities_edit');
$router->map('POST', '/database_utilities/update', 'DatabaseUtilitiesController@update', 'database_utilities_update');
$router->map('POST', '/database_utilities/delete', 'DatabaseUtilitiesController@delete', 'database_utilities_delete');
// Register with message board server
$router->map('GET', '/register_messaging', 'RegisterSiteController@registerForMessages', 'register_messaging');
// Register with content server
$router->map('GET', '/register_content', 'RegisterSiteController@registerForContent', 'register_content');

// Admin routes for managing sponsors
$router->map('GET', '/admin/sponsors', 'AdminController@indexSponsors', 'admin_sponsors');
$router->map('GET|POST', '/admin/sponsors/create', 'AdminController@createSponsor', 'admin_create_sponsor');
$router->map('GET|POST', '/admin/sponsors/edit/[*:id]', 'AdminController@editSponsor', 'admin_edit_sponsor');
$router->map('GET', '/admin/sponsors/delete/[*:id]', 'AdminController@deleteSponsor', 'admin_delete_sponsor');

// Admin routes
$router->map('GET', '/admin', 'AdminController@index', 'admin_home');
$router->map('GET|POST', '/admin/login', 'AdminController@login', 'admin_login');
$router->map('GET', '/admin/logout', 'AdminController@logout', 'admin_logout');
$router->map('GET|POST', '/admin/create', 'AdminController@create', 'admin_create');
$router->map('GET|POST', '/admin/edit/[*:id]', 'AdminController@edit', 'admin_edit');
$router->map('GET', '/admin/delete/[*:id]', 'AdminController@delete', 'admin_delete');

// Return the router instance
return $router;