<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title>Index</title>
    <style type="text/css">
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            overflow: hidden;
        }
        iframe {
            display: block;
            width: 1080px;
            height: 100%;
            margin: 0;
        }
        #feedback {
            display: block;
            position: fixed;
            top: 10%;
            left: 50%;
            width: 75%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.5);
            color: white;
            padding: 20px;
            border-radius: 10px;
            font-size: 2em;
            font-family: "Open Sans ExtraBold", sans-serif;
            z-index: 1;
            text-align: center;
            opacity: 0;
            animation: fadeinout 5s linear;
        }
        @keyframes fadeinout {
            0% { opacity: 0; }
            50% { opacity: 1; }
            100% { opacity: 0; }
        }
        .video_inset {
            margin: auto;
        }
        .video_size {
            width: 67.5rem;
            height: 116.875rem;
        }
    </style>
</head>
<body style="background-color: black">
<?php
session_start();

if (!isset($_SESSION['current_playlist_index'])) {
    $_SESSION['current_playlist_index'] = 0;
}

$i = $_SESSION['current_playlist_index'];
?>
<div id="feedback">
    Touch the screen to return to the index
</div>
<div style="position: relative; width: 67.5rem; height: 116.875rem;">
    <?php
    if ($_SESSION['playlist'][$i]['type'] == 'mp4') {
        echo "<div class='video_inset'>";
        echo "<video class='video_size' src='/" . $_SESSION['playlist'][$i]['link'] . "' muted autoplay></video>";
        echo "</div>";
    } elseif ($_SESSION['playlist'][$i]['type'] == 'link') {
        echo $_SESSION['playlist'][$i]['link'];
    }
    $_SESSION['current_playlist_index'] = ($i + 1) % count($_SESSION['playlist']);
    ?>
    <a href="/index">
        <div id="overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 2;"></div>
    </a>
</div>
<script>
    let iframe = document.querySelector('iframe');
    let video = document.querySelector('video');
    let feedback = document.getElementById('feedback');
    let showFeedback = function() {
        if (feedback) {
            feedback.style.animation = 'fadeinout 5s linear';
        }
    };
    if (iframe) {
        iframe.onload = showFeedback;
    }
    if (video) {
        video.onloadeddata = showFeedback;
    }
    let duration = <?php echo json_encode($_SESSION['playlist'][$i]['play_for'] ?? 0); ?>;
    setTimeout(function() {
        window.location.href = '/public/views/show_idle.view.php';
    }, duration * 1000);
</script>
</body>
</html>