<?php /** @noinspection ALL */
/** @noinspection ALL */
/** @noinspection ALL */
/** @noinspection ALL */
/** @noinspection ALL */

/** @noinspection ALL */

namespace Controllers;

use App\Logging;
use App\SQLiteConnection;
use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Exception\RequestException;
use PDO;
use Controllers\Playlist;

// Logger Class
require_once('app/Logging.php');

require 'vendor/autoload.php';

class ContentDownloaderController
{
    private PDO $pdo;
    private $jsonData;
    private Logging $log;
    private $siteRef;
    private $siteId;
    private $contentAPI;
    private $contentLocalPath;
    private $appendToPlaylist;
    private Client $client;
    private Playlist $playlist;

    public function __construct(SQLiteConnection $connection)
    {
        $this->pdo = $connection->getPDO();
        $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $this->log = new Logging();
        $this->log->lfile('logs/content.log');
        $this->log->lwrite('======= CONTENT LOGGING STARTED ' . date('d/m/Y H:i') . ' ========');
        $this->initializePathsAndId();
        $this->client = new Client(); // Guzzle client is instantiated here
        $this->playlist = new Playlist();
    }

    private function initializePathsAndId(): void
    {
        try {
            $config = parse_ini_file('public/config/site.cfg');
            $this->siteRef = $config['site_ref'];
            $this->contentAPI = $config['url_to_content_api'];
            $this->contentLocalPath = $config['path_to_content'];
            $this->appendToPlaylist = $config['add_content_to_playlist'];
        } catch (Exception $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
        }
    }


    public function getJSONData($url): void
    {
        try {
            $response = $this->client->get($url);
            $this->jsonData = json_decode($response->getBody(), true);

            if (empty($this->jsonData)) {
                throw new Exception('No JSON data found');
            }

        } catch (RequestException $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
        } catch (GuzzleException $e) {
            $this->log->lwrite("Guzzle Error: " . $e->getMessage());
        } catch (Exception $e) {
            $this->log->lwrite($e->getMessage());
            echo $e->getMessage() . "\n";
        }
    }


    public function logSchedule($schedule): void
    {
        $this->log->lwrite("Schedule ID: " . $schedule['id']);
        $this->log->lwrite("Title: " . $schedule['title']);
        $this->log->lwrite("Updated At: " . $schedule['updated_at']);
        echo "Schedule ID: " . $schedule['id'] . " successfully read\n";
    }

    public function downloadItems($scheduleId): bool
    {
        $allDownloadsSuccessful = true; // Initialize success status
        /*echo '<pre>';
        print_r($this->jsonData[0]['items']);
        echo '</pre>';
        die(); */
        foreach ($this->jsonData[0]['items'] as $item) {
            if ($item['schedule_id'] == $scheduleId) {
                $fileName = $item['file'];
                $url = $this->contentAPI . 'get-file?file_path=' . $fileName;
                $savePath = $this->contentLocalPath . $fileName;

                if ($this->downloadFile($url, $savePath)) {
                    $this->logItemDownload($item['id']);
                } else {
                    $this->log->lwrite("Failed to download file " . $savePath);
                    $allDownloadsSuccessful = false; // Update success status
                }
            }
        }

        return $allDownloadsSuccessful; // Return overall success status
    }

    function downloadFile($url, $savePath): bool
    {
        try {
            $response = $this->client->get($url, ['sink' => $savePath]);
            echo "Downloading " . $savePath . "\n";
            if ($response->getStatusCode() == 200) {
                $this->log->lwrite($savePath . " downloaded successfully");
                return true;
            } else {
                $this->log->lwrite("Failed to download file " . $savePath . " with status code: " . $response->getStatusCode());
                return false;
            }
        } catch (RequestException $e) {
            $this->log->lwrite("Request Error: " . $e->getMessage());
            $this->log->lwrite("Request Exception: " . $e);
            return false;
        } catch (GuzzleException $e) {
            $this->log->lwrite("Guzzle Error: " . $e->getMessage());
            $this->log->lwrite("Guzzle Exception: " . $e);
            return false;
        }
    }

    function logItemDownload($id): void
    {
        $client = new Client();
        $url = $this->contentAPI . 'log-upload?id=' . $id;
        $data = ['id' => $id];

        try {
            $response = $client->post($url, [
                'form_params' => $data
            ]);

            if ($response->getStatusCode() == 200) {
                $this->log->lwrite("Download successful for Item ID: " . $id);
                echo "Download successful for Item ID: " . $id . "\n";
            } else {
                $this->log->lwrite("Failed to log download for Item ID: " . $id);
                echo "Failed to log download for Item ID: " . $id . "\n";
            }
        } catch (RequestException $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
            echo "Error: " . $e->getMessage() . "\n";
        } catch (GuzzleException $e) {
            $this->log->lwrite("Guzzle Error: " . $e->getMessage());
            echo "Guzzle Error: " . $e->getMessage() . "\n";
        }
    }

    public function updateAdvertisers(): void
    {
        try {
            $this->log->lwrite("Updating advertisers");
            // Remove the redundant json_decode call
            $advertisers = $this->jsonData[0]['advertisers'];

            if (!empty($advertisers)) {
                foreach ($advertisers as $advertiser) {
                    $stmt = $this->pdo->prepare("SELECT COUNT(*) FROM sponsors WHERE contract = :contract");
                    $stmt->execute(['contract' => $advertiser['contract']]);
                    $exists = $stmt->fetchColumn() > 0;

                    if ($exists) {
                        $stmt = $this->pdo->prepare("UPDATE sponsors SET business_name = :business_name, address_1 = :address_1, address_2 = :address_2, street = :street, city = :city, county = :county, postal_code = :postal_code, country = :country, phone = :phone, mobile = :mobile, email = :email, url = :url, social = :social, banner = :banner, button = :button, mp4 = :mp4 WHERE contract = :contract");
                        $this->log->lwrite("Updated: " . $advertiser['contract'] . " - " . $advertiser['business_name']);
                    } else {
                        $stmt = $this->pdo->prepare("INSERT INTO sponsors (contract, business_name, address_1, address_2, street, city, county, postal_code, country, phone, mobile, email, url, social, banner, button, mp4) VALUES (:contract, :business_name, :address_1, :address_2, :street, :city, :county, :postal_code, :country, :phone, :mobile, :email, :url, :social, :banner, :button, :mp4)");
                        $this->log->lwrite("Inserted: " . $advertiser['contract'] . " - " . $advertiser['business_name']);
                    }

                    $stmt->execute([
                        'contract' => $advertiser['contract'],
                        'business_name' => $advertiser['business_name'],
                        'address_1' => $advertiser['address_1'],
                        'address_2' => $advertiser['address_2'],
                        'street' => $advertiser['street'],
                        'city' => $advertiser['city'],
                        'county' => $advertiser['county'],
                        'postal_code' => $advertiser['postal_code'],
                        'country' => $advertiser['country'],
                        'phone' => $advertiser['phone'],
                        'mobile' => $advertiser['mobile'],
                        'email' => $advertiser['email'],
                        'url' => $advertiser['url'],
                        'social' => $advertiser['social'],
                        'banner' => $advertiser['banner'],
                        'button' => $advertiser['button'],
                        'mp4' => $advertiser['mp4']
                    ]);
                }
                // Instantiate and run the QRController
                $qrController = new QRController();
                $qrController->handleRequest();
            }
        } catch (Exception $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
        }
    }

    public function getSiteId(): void
    {
        $client = new Client();
        $url = $this->contentAPI . 'get-site-id?site_ref=' . $this->siteRef;

        try {
            $response = $client->get($url);
            $data = json_decode($response->getBody(), true);

            if (isset($data['id'])) {
                $this->siteId = $data['id'];
                $this->log->lwrite("Site ID retrieved successfully: " . $this->siteId);
            } else {
                $this->log->lwrite("Failed to retrieve Site ID");
            }
        } catch (RequestException $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
        } catch (GuzzleException $e) {
            $this->log->lwrite("Guzzle Error: " . $e->getMessage());
        }
    }

    public function addFilesToPlaylist(): void
    {
        $mp4Items = array_filter($this->jsonData[0]['items'], function($item) {
            return $item['resource_type'] === 'mp4';
        });

        if (count($mp4Items) > 0) {
            $csvPath = 'public/sponsor_assets/mp4s/files.csv';

            // Check if the CSV file exists, if not create it with the header row
            if (!file_exists($csvPath)) {
                $csvFile = fopen($csvPath, 'w');
                fputcsv($csvFile, ['id', 'description', 'time_on', 'date_on', 'time_off', 'date_off', 'link', 'play_for', 'display_on_idle', 'type']);
                fclose($csvFile);
            }

            // Append items to the CSV file
            $csvFile = fopen($csvPath, 'a');
            foreach ($mp4Items as $item) {
                $id = $item['id'];
                $description = $item['description'] ?? 'NULL';
                $timeOn = $item['time_on'] ?? 'NULL';
                $dateOn = $item['date_on'] ?? 'NULL';
                $timeOff = $item['time_off']?? 'NULL' ;
                $dateOff = $item['date_off'] ?? 'NULL';
                $link = 'public/sponsor_assets/' . $item['file'];
                $playFor = $this->playlist->getVideoDuration($link);
                $displayOnIdle = $item['display_on_idle'] ?? 1;
                $type = $item['resource_type'] ?? 'NULL';

                fputcsv($csvFile, [$id, $description, $timeOn, $dateOn, $timeOff, $dateOff, $link, $playFor, $displayOnIdle, $type]);

                // Log the addition of the item to the playlist
                $this->log->lwrite($item['file'] . ' added to playlist');
            }
            fclose($csvFile);
        }
    }

    function logScheduleDownload($scheduleId, $siteId): void
    {
        $client = new Client();
        $url = $this->contentAPI . 'log-schedule?schedule_id=' . $scheduleId . '&site_id=' . $siteId;
        $data = ['schedule_id' => $scheduleId, 'site_id' => $siteId];

        try {
            $response = $client->post($url, [
                'form_params' => $data
            ]);

            if ($response->getStatusCode() == 200) {
                $this->log->lwrite("Log upload with server successful for Schedule ID: " . $scheduleId);
                echo "Log upload with server successful for Schedule ID: " . $scheduleId . "\n";
            } else {
                $this->log->lwrite("Failed to log upload for ID: " . $scheduleId);
                echo "Failed to log upload for ID: " . $scheduleId . "\n";
            }
        } catch (RequestException $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
        } catch (GuzzleException $e) {
            $this->log->lwrite("Guzzle Error: " . $e->getMessage());
        }
    }

    private function logSiteUpdate(): void
    {
        $client = new Client();
        $url = $this->contentAPI . 'log-site-update';
        $data = ['site_id' => $this->siteId];

        try {
            $response = $client->post($url, [
                'form_params' => $data
            ]);

            if ($response->getStatusCode() == 200) {
                $this->log->lwrite("Site update logged successfully for Site ID: " . $this->siteId);
                echo "Site update logged successfully for Site ID: " . $this->siteId . "\n";
            } else {
                $this->log->lwrite("Failed to log site update for Site ID: " . $this->siteId);
                echo "Failed to log site update for Site ID: " . $this->siteId . "\n";
            }
        } catch (RequestException $e) {
            $this->log->lwrite("Error: " . $e->getMessage());
            echo "Error: " . $e->getMessage() . "\n";
        } catch (GuzzleException $e) {
            $this->log->lwrite("Guzzle Error: " . $e->getMessage());
            echo "Guzzle Error: " . $e->getMessage() . "\n";
        }
    }

    public function run(): bool
    {
        $this->getSiteId();
        $url = $this->contentAPI . 'schedules/' . $this->siteRef;
        $this->getJSONData($url);

        // Check if the response contains the message 'No schedules available for download.'
        if (isset($this->jsonData['message']) && $this->jsonData['message'] === 'No schedules available for download.') {
            $this->log->lwrite($this->jsonData['message']);
            echo $this->jsonData['message'] . "\n";
            return true; // Indicates there was no content to download
        }

        $errorOccurred = false;

        // log schedule locally and download items
        try {
            foreach ($this->jsonData[0]['schedules'] as $schedule) {
                $this->logSchedule($schedule);
                if (!$this->downloadItems($schedule['id'])) {
                    $errorMessage = "Error downloading schedule item with ID: " . $schedule['id'];
                    $this->log->lwrite($errorMessage);
                    echo $errorMessage . "\n";
                    return false; // Halt execution
                }
            }
        } catch (Exception $e) {
            $errorMessage = "The schedule data could not be read: " . $e->getMessage();
            $this->log->lwrite($errorMessage);
            echo $errorMessage . "\n";
            return false; // Halt execution
        }

        // update advertisers database
        $this->updateAdvertisers();

        if ($this->appendToPlaylist) {
            $this->addFilesToPlaylist();
        }

        // log schedule download at server
        foreach ($this->jsonData[0]['schedules'] as $schedule) {
            $scheduleId = $schedule['id'];
            $this->logScheduleDownload($scheduleId, $this->siteId);
        }

        // log site update
        $this->logSiteUpdate();

        return !$errorOccurred; // Indicate success if no errors occurred
    }

    // method to make API call to content server to update last contact status of site
        public function updateSiteLastContact(): void
        {
            $client = new Client();
            $url = $this->contentAPI . 'update-last-contact';
            $data = ['site_id' => $this->siteId];

            try {
                $response = $client->post($url, [
                    'form_params' => $data
                ]);

                if ($response->getStatusCode() == 200) {
                    $this->log->lwrite("Last contact status updated successfully for Site ID: " . $this->siteId);
                    echo "Last contact status updated successfully for Site ID: " . $this->siteId . "\n";
                } else {
                    $this->log->lwrite("Failed to update last contact status for Site ID: " . $this->siteId);
                    echo "Failed to update last contact status for Site ID: " . $this->siteId . "\n";
                }
            } catch (RequestException $e) {
                $this->log->lwrite("Error: " . $e->getMessage());
                echo "Error: " . $e->getMessage() . "\n";
            } catch (GuzzleException $e) {
                $this->log->lwrite("Guzzle Error: " . $e->getMessage());
                echo "Guzzle Error: " . $e->getMessage() . "\n";
            }
        }
}

