<?php
// Database configuration
$dbPath = __DIR__ . '/sponsor_content.db';

try {
    // Connect to SQLite database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Count sponsors
    $count = $db->query("SELECT COUNT(*) FROM sponsors")->fetchColumn();
    echo "Found $count sponsors in the database.\n\n";
    
    if ($count > 0) {
        // Show first 5 sponsors
        $sponsors = $db->query("SELECT id, business_name, is_active FROM sponsors LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
        echo "Sample sponsors:\n";
        foreach ($sponsors as $sponsor) {
            echo "- ID: {$sponsor['id']}, Name: {$sponsor['business_name']}, Active: {$sponsor['is_active']}\n";
        }
    } else {
        echo "No sponsors found in the database. You'll need to add some through the admin interface.\n";
    }
    
    // Check if the sponsors table has the correct structure
    $columns = $db->query("PRAGMA table_info('sponsors')")->fetchAll(PDO::FETCH_COLUMN, 1);
    $requiredColumns = ['business_name', 'is_active', 'display_order'];
    $missingColumns = array_diff($requiredColumns, $columns);
    
    if (!empty($missingColumns)) {
        echo "\nWARNING: Missing required columns: " . implode(', ', $missingColumns) . "\n";
    } else {
        echo "\nDatabase structure looks good!\n";
    }
    
} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
?>
