<?php
// Set headers first to ensure no output before them
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Function to send JSON error response
function sendError($message, $code = 500) {
    http_response_code($code);
    echo json_encode(['error' => $message]);
    exit;
}

// Enable error reporting for development
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../../error.log');
error_reporting(E_ALL);

// Include the RingCentral PHP SDK
try {
    require_once __DIR__ . '/../vendor/autoload.php';
} catch (Exception $e) {
    sendError('Failed to load dependencies. Please run composer install.', 500);
}

// Configuration
$config = [
    'client_id' => '1CayFASqF2Qdv1MFI2nDgo',
    'client_secret' => 'Xim1wYJpsORcp3d4KrwrjHZr9t2ckc8H9cvPkhtmHxpV',
    'server_url' => 'https://platform.ringcentral.com',
    'jwt' => [
        'Reports' => 'eyJraWQiOiI4NzYyZjU5OGQwNTk0NGRiODZiZjVjYTk3ODA0NzYwOCIsInR5cCI6IkpXVCIsImFsZyI6IlJTMjU2In0.eyJhdWQiOiJodHRwczovL3BsYXRmb3JtLnJpbmdjZW50cmFsLmNvbS9yZXN0YXBpL29hdXRoL3Rva2VuIiwic3ViIjoiMjIzNzIxMDQyIiwiaXNzIjoiaHR0cHM6Ly9wbGF0Zm9ybS5yaW5nY2VudHJhbC5jb20iLCJleHAiOjIyNDAyNjU1OTksImlhdCI6MTcwMTEwMzI5MywianRpIjoiYkxGZDJqOTVSUWk2THROcW1JLVhFZyJ9.ALtTujcoO5CNQmkh-YX-tMibPE2Szx3Kzt8PsEKPetygnW23HCpKtaXufDjgG_qMe5PxfcuGQgLITU3gGh_H4k4kSIlviyJTrWwiwwOcBTsorNbIQMjbVwNdpMZGfzCf1bqkAFq7FIJMfR0KopXSBSL5RsnkWa12Vm_uUEQBIpiZd0T0F9uVJeaVcQlOPr4dK1zae3XEtqubdWT6xyAqli-glTj4IDgn-VNfM2WGk63QMb6ApraALmwulNCjqNPK6bJ7Q2U65zMPRDJmfy-jVpdS7KABBuj76bt0itBwt_-EdYp92DjB8-aHEsJiaLOYMW2bKuAqq95hHlJbnQ45fQ'
    ]
];

// Hidden users
$hidden_users = ["Emma Crane", "Nathan Oliver", "Fran Ferreria", "Elaine Fogarty"];

// Helper function to format duration
function format_duration($seconds) {
    if ($seconds < 0) $seconds = 0;
    $hours = floor($seconds / 3600);
    $minutes = floor(($seconds % 3600) / 60);
    $secs = $seconds % 60;
    return sprintf("%02d:%02d:%02d", $hours, $minutes, $secs);
}

function format_time_ago($timestamp) {
    $now = new DateTime('now', new DateTimeZone('UTC'));
    $diff = $now->diff(new DateTime('@' . $timestamp, new DateTimeZone('UTC')));
    $minutes_ago = $diff->days * 24 * 60 + $diff->h * 60 + $diff->i;
    
    if ($minutes_ago < 1) {
        return 'just now';
    } elseif ($minutes_ago < 60) {
        return $minutes_ago . ' minute' . ($minutes_ago != 1 ? 's' : '') . ' ago';
    } else {
        $hours_ago = floor($minutes_ago / 60);
        $remaining_minutes = $minutes_ago % 60;
        if ($remaining_minutes == 0) {
            return $hours_ago . ' hour' . ($hours_ago != 1 ? 's' : '') . ' ago';
        } else {
            return $hours_ago . 'h ' . $remaining_minutes . 'm ago';
        }
    }
}

try {
    // Initialize RingCentral SDK
    $rcsdk = new RingCentral\SDK\SDK($config['client_id'], $config['client_secret'], $config['server_url']);
    $platform = $rcsdk->platform();
    
    // Authenticate with JWT
    $platform->login(['jwt' => $config['jwt']['Reports']]);
    
    // Get the date for the beginning of the week (Monday)
    $dateFrom = new DateTime('monday this week', new DateTimeZone('UTC'));
    $dateFrom->setTime(0, 0, 0);
    $dateFrom_iso = $dateFrom->format('Y-m-d\TH:i:s.\0\0\0\Z');
    
    // Fetch outbound calls for the week
    $outbound_response = $platform->get('/restapi/v1.0/account/~/call-log', [
        'dateFrom' => $dateFrom_iso,
        'type' => 'Voice',
        'direction' => 'Outbound',
        'view' => 'Detailed',
        'perPage' => 1000
    ]);
    
    // Fetch inbound calls for the week
    $inbound_response = $platform->get('/restapi/v1.0/account/~/call-log', [
        'dateFrom' => $dateFrom_iso,
        'type' => 'Voice',
        'direction' => 'Inbound',
        'view' => 'Detailed',
        'perPage' => 1000
    ]);
    
    $outbound_records = $outbound_response->json()->records;
    $inbound_records = $inbound_response->json()->records;
    $all_records = array_merge($outbound_records, $inbound_records);
    
    // Process all weekly records for the leaderboard
    $weekly_user_data = [];
    foreach ($all_records as $record) {
        $direction = $record->direction ?? '';
        $from_name = $record->from->name ?? 'Unknown';
        $to_name = $record->to->name ?? 'Unknown';
        $duration = $record->duration ?? 0;
        
        if ($direction === 'Outbound') {
            $user_name = $from_name;
        } else {
            // Inbound: default to the "to" name
            $user_name = $to_name;
            // If the top-level "to" is generic (main number / queue / ivr) or unknown, try to resolve agent from legs
            $needs_leg_lookup = ($user_name === 'Unknown' || $user_name === '' || preg_match('/(main|company|queue|ivr|sales|support)/i', $user_name));
            if ($needs_leg_lookup && isset($record->legs) && is_array($record->legs)) {
                foreach ($record->legs as $leg) {
                    if (isset($leg->extension) && isset($leg->extension->name) && $leg->extension->name) {
                        $user_name = $leg->extension->name;
                        break;
                    }
                    if (isset($leg->to) && isset($leg->to->name) && $leg->to->name) {
                        $user_name = $leg->to->name;
                        break;
                    }
                    if (isset($leg->from) && isset($leg->from->name) && $leg->from->name) {
                        $user_name = $leg->from->name;
                        break;
                    }
                }
            }
        }

        // Skip if user is unknown or in the hidden list
        if ($user_name === 'Unknown' || in_array($user_name, $hidden_users)) {
            continue;
        }
        
        if (!isset($weekly_user_data[$user_name])) {
            $weekly_user_data[$user_name] = [
                'name' => $user_name,
                'last_call_timestamp' => 0,
                'outbound_count' => 0,
                'outbound_duration' => 0,
                'inbound_count' => 0,
                'inbound_duration' => 0
            ];
        }
        
        $record_timestamp = strtotime($record->startTime);
        if ($record_timestamp > $weekly_user_data[$user_name]['last_call_timestamp']) {
            $weekly_user_data[$user_name]['last_call_timestamp'] = $record_timestamp;
        }
        
        if ($direction === 'Outbound') {
            $weekly_user_data[$user_name]['outbound_count']++;
            $weekly_user_data[$user_name]['outbound_duration'] += $duration;
        } elseif ($direction === 'Inbound') {
            $weekly_user_data[$user_name]['inbound_count']++;
            $weekly_user_data[$user_name]['inbound_duration'] += $duration;
        }
    }
    
    // Calculate totals and format for weekly data
    $weekly_results = [];
    foreach ($weekly_user_data as $user) {
        $total_duration = $user['outbound_duration'] + $user['inbound_duration'];
        $weekly_results[] = [
            'name' => $user['name'],
            'last_call_ago' => format_time_ago($user['last_call_timestamp']),
            'outbound_count' => $user['outbound_count'],
            'outbound_time' => format_duration($user['outbound_duration']),
            'inbound_count' => $user['inbound_count'],
            'inbound_time' => format_duration($user['inbound_duration']),
            'total_time' => format_duration($total_duration)
        ];
    }
    
    // Sort weekly results by total time for the leaderboard
    usort($weekly_results, function($a, $b) {
        $timeA = strtotime($a['total_time']) - strtotime('00:00:00');
        $timeB = strtotime($b['total_time']) - strtotime('00:00:00');
        return $timeB - $timeA;
    });

    // Get top 3 for the leaderboard
    $leaderboard = array_slice($weekly_results, 0, 3);

    // Now, process only today's records for the main dashboard
    $daily_user_data = [];
    $today_start = new DateTime('today', new DateTimeZone('UTC'));
    $today_start->setTime(0, 0, 0);

    foreach ($all_records as $record) {
        $record_time = new DateTime($record->startTime, new DateTimeZone('UTC'));
        if ($record_time < $today_start) {
            continue; // Skip records from before today
        }

        $direction = $record->direction ?? '';
        $from_name = $record->from->name ?? 'Unknown';
        $to_name = $record->to->name ?? 'Unknown';
        $duration = $record->duration ?? 0;
        
        if ($direction === 'Outbound') {
            $user_name = $from_name;
        } else {
            // Inbound: default to the "to" name
            $user_name = $to_name;
            // If the top-level "to" is generic (main number / queue / ivr) or unknown, try to resolve agent from legs
            $needs_leg_lookup = ($user_name === 'Unknown' || $user_name === '' || preg_match('/(main|company|queue|ivr|sales|support)/i', $user_name));
            if ($needs_leg_lookup && isset($record->legs) && is_array($record->legs)) {
                foreach ($record->legs as $leg) {
                    if (isset($leg->extension) && isset($leg->extension->name) && $leg->extension->name) {
                        $user_name = $leg->extension->name;
                        break;
                    }
                    if (isset($leg->to) && isset($leg->to->name) && $leg->to->name) {
                        $user_name = $leg->to->name;
                        break;
                    }
                    if (isset($leg->from) && isset($leg->from->name) && $leg->from->name) {
                        $user_name = $leg->from->name;
                        break;
                    }
                }
            }
        }
        
        // Skip if user is unknown or in the hidden list
        if ($user_name === 'Unknown' || in_array($user_name, $hidden_users)) {
            continue;
        }

        if (!isset($daily_user_data[$user_name])) {
            $daily_user_data[$user_name] = [
                'name' => $user_name,
                'last_call_timestamp' => 0,
                'outbound_count' => 0,
                'outbound_duration' => 0,
                'inbound_count' => 0,
                'inbound_duration' => 0
            ];
        }
        
        $record_timestamp = strtotime($record->startTime);
        if ($record_timestamp > $daily_user_data[$user_name]['last_call_timestamp']) {
            $daily_user_data[$user_name]['last_call_timestamp'] = $record_timestamp;
        }
        
        if ($direction === 'Outbound') {
            $daily_user_data[$user_name]['outbound_count']++;
            $daily_user_data[$user_name]['outbound_duration'] += $duration;
        } elseif ($direction === 'Inbound') {
            $daily_user_data[$user_name]['inbound_count']++;
            $daily_user_data[$user_name]['inbound_duration'] += $duration;
        }
    }

    // Calculate totals and format for daily results
    $daily_results = [];
    foreach ($daily_user_data as $user) {
        $total_duration = $user['outbound_duration'] + $user['inbound_duration'];
        $daily_results[] = [
            'name' => $user['name'],
            'last_call_ago' => format_time_ago($user['last_call_timestamp']),
            'outbound_count' => $user['outbound_count'],
            'outbound_time' => format_duration($user['outbound_duration']),
            'inbound_count' => $user['inbound_count'],
            'inbound_time' => format_duration($user['inbound_duration']),
            'total_time' => format_duration($total_duration)
        ];
    }

    // Sort daily results by name for the main table
    usort($daily_results, function($a, $b) {
        return strcmp($a['name'], $b['name']);
    });

    // Initialize response array
    $response = [
        'status' => 'success',
        'data' => [
            'callLogs' => $daily_results,
            'leaderboard' => $leaderboard
        ],
        'timestamp' => gmdate('Y-m-d\TH:i:s.\0\0\0\Z')
    ];
    
    echo json_encode($response);
    
} catch (Exception $e) {
    sendError('Failed to fetch call logs: ' . $e->getMessage(), 500);
}
