<?php
$output = shell_exec('python "H:/xampp/htdocs/calllogs/call_logs.py"');
$call_logs = json_decode($output, true);

if (isset($call_logs['error'])) {
    $error = $call_logs['error'];
    $call_logs = [];
} elseif (!is_array($call_logs)) {
    $error = "Python output was not a valid JSON array.";
    $call_logs = [];
} else {
    $error = "";
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>📞 Canada Call Logs</title>
    <meta http-equiv="refresh" content="20">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #000;
            color: #fff;
            padding: 40px;
            margin: 0;
            overflow: hidden;
        }

        h1 {
            font-size: 64px;
            margin-bottom: 20px;
            color: #00e6e6;
        }

        .clock {
            position: absolute;
            top: 20px;
            right: 40px;
            font-size: 48px;
            font-weight: bold;
            color: #ffcc00;
        }

        ul {
            list-style: none;
            padding: 0;
            margin-top: 40px;
        }

        li {
            font-size: 36px;
            background: #111;
            padding: 20px;
            margin-bottom: 15px;
            border-left: 10px solid #00e6e6;
            animation: fadeIn 0.5s ease-in;
            border-radius: 5px;
        }

        .error {
            color: #ff4d4d;
            font-size: 36px;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <div class="clock" id="clock">--:--:--</div>

    <h1>📞 RingCentral Canada Call Logs</h1>

    <?php if ($error): ?>
        <p class="error">⚠️ <?php echo htmlspecialchars($error); ?></p>
    <?php endif; ?>

    <ul>
        <?php foreach ($call_logs as $entry): ?>
            <li>
                <?php echo htmlspecialchars($entry['name']); ?> - 
                Total: <?php echo htmlspecialchars($entry['total_time']); ?>, 
                Last call: <?php echo htmlspecialchars($entry['last_call_ago']); ?>
            </li>
        <?php endforeach; ?>
    </ul>

    <script>
        function updateClock() {
            const now = new Date();
            const h = String(now.getHours()).padStart(2, '0');
            const m = String(now.getMinutes()).padStart(2, '0');
            const s = String(now.getSeconds()).padStart(2, '0');
            document.getElementById('clock').textContent = `${h}:${m}:${s}`;
        }
        setInterval(updateClock, 1000);
        updateClock();
    </script>
</body>
</html>