import time
from ringcentral import SDK
import json
from collections import defaultdict
from datetime import datetime, timezone

# Setup
config = {
    "client_id": "1CayFASqF2Qdv1MFI2nDgo",
    "client_secret": "Xim1wYJpsORcp3d4KrwrjHZr9t2ckc8H9cvPkhtmHxpV",
    "server_url": "https://platform.ringcentral.com",
    "jwt": {
        "Reports": "eyJraWQiOiI4NzYyZjU5OGQwNTk0NGRiODZiZjVjYTk3ODA0NzYwOCIsInR5cCI6IkpXVCIsImFsZyI6IlJTMjU2In0.eyJhdWQiOiJodHRwczovL3BsYXRmb3JtLnJpbmdjZW50cmFsLmNvbS9yZXN0YXBpL29hdXRoL3Rva2VuIiwic3ViIjoiMjIzNzIxMDQyIiwiaXNzIjoiaHR0cHM6Ly9wbGF0Zm9ybS5yaW5nY2VudHJhbC5jb20iLCJleHAiOjIyNDAyNjU1OTksImlhdCI6MTcwMTEwMzI5MywianRpIjoiYkxGZDJqOTVSUWk2THROcW1JLVhFZyJ9.ALtTujcoO5CNQmkh-YX-tMibPE2Szx3Kzt8PsEKPetygnW23HCpKtaXufDjgG_qMe5PxfcuGQgLITU3gGh_H4k4kSIlviyJTrWwiwwOcBTsorNbIQMjbVwNdpMZGfzCf1bqkAFq7FIJMfR0KopXSBSL5RsnkWa12Vm_uUEQBIpiZd0T0F9uVJeaVcQlOPr4dK1zae3XEtqubdWT6xyAqli-glTj4IDgn-VNfM2WGk63QMb6ApraALmwulNCjqNPK6bJ7Q2U65zMPRDJmfy-jVpdS7KABBuj76bt0itBwt_-EdYp92DjB8-aHEsJiaLOYMW2bKuAqq95hHlJbnQ45fQ"
    }
}

hidden_users = ["Emma Crane", "Nathan Oliver", "Fran Ferreria"]

rcsdk = SDK(config["client_id"], config["client_secret"], config["server_url"])
platform = rcsdk.platform()

# Login
try:
    platform.login(jwt=config["jwt"]["Reports"])
except Exception as e:
    print(json.dumps({"error": f"Login failed: {str(e)}"}))
    exit()

today_iso = datetime.utcnow().strftime('%Y-%m-%dT00:00:00.000Z')

# Retry logic
max_retries = 5
retry_delay = 1
response = None

for attempt in range(max_retries):
    try:
        response = platform.get('/restapi/v1.0/account/~/call-log', {
            'dateFrom': today_iso,
            'type': 'Voice',
            'direction': 'Outbound'
        })
        break
    except Exception as e:
        if 'Request rate exceeded' in str(e):
            time.sleep(retry_delay)
            retry_delay *= 2
        else:
            print(json.dumps({"error": f"Failed to fetch call logs: {str(e)}"}))
            exit()

if response is None:
    print(json.dumps({"error": "Max retries exceeded. Could not fetch call logs."}))
    exit()

try:
    call_logs = json.loads(response.text())
    user_data = {}

    for record in call_logs.get('records', []):
        if record.get('direction') != 'Outbound':
            continue

        from_info = record.get('from', {})
        user_name = from_info.get('name') or from_info.get('extensionNumber') or "Unknown"
        if user_name in hidden_users:
            continue

        # Get actual talk time from legs if available
        duration = 0
        legs = record.get('legs', [])
        if legs:
            # Sum up connected time from all legs
            for leg in legs:
                if leg.get('legType') == 'Accept':
                    duration += leg.get('duration', 0)
        
        # Fallback to total duration if no leg data
        if duration == 0:
            duration = record.get('duration', 0)

        start_time_str = record.get('startTime')
        if start_time_str:
            start_time = datetime.fromisoformat(start_time_str.replace("Z", "+00:00"))

            if user_name not in user_data:
                user_data[user_name] = {
                    "total_duration": 0,
                    "last_call_time": start_time
                }

            user_data[user_name]["total_duration"] += duration
            if start_time > user_data[user_name]["last_call_time"]:
                user_data[user_name]["last_call_time"] = start_time

    results = []
    now = datetime.now(timezone.utc)

    for user, data in sorted(user_data.items(), key=lambda x: -x[1]["total_duration"]):
        total_secs = data["total_duration"]
        mins, secs = divmod(total_secs, 60)
        hrs, mins = divmod(mins, 60)

        if hrs > 0:
            total_time_str = f"{hrs}hr {mins}min"
        else:
            total_time_str = f"{mins}min"

        time_diff = now - data["last_call_time"]
        minutes_ago = int(time_diff.total_seconds() // 60)

        if minutes_ago < 1:
            last_call_str = "just now"
        elif minutes_ago < 60:
            last_call_str = f"{minutes_ago} minutes ago"
        else:
            hours_ago = minutes_ago // 60
            last_call_str = f"{hours_ago} hour{'s' if hours_ago > 1 else ''} ago"

        results.append({
            "name": user,
            "total_time": total_time_str,
            "last_call_ago": last_call_str
        })

    print(json.dumps(results))

except Exception as e:
    print(json.dumps({"error": f"Failed to process call logs: {str(e)}"}))