<?php
/** @var array $settings */
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Config Utilities</title>
    <link rel="stylesheet" type="text/css" href="app_assets/css/bootstrap.min.css">
</head>
<body>
<?php
require('public/views/partials/navbar.php');
?>

<?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger" role="alert">
        <?= is_array($_SESSION['error']) ? implode(', ', $_SESSION['error']) : $_SESSION['error']; ?>
    </div>
<?php endif; ?>

<?php if (isset($successMessage)): ?>
    <div class="alert alert-success">
        <?php echo htmlspecialchars($successMessage); ?>
    </div>
<?php endif; ?>

<div class="container d-flex flex-column align-items-center mt-5">
    <h1>Configuration</h1>
    <br>
    <h3>Configure app settings for site</h3>
    <div class="col-6 mx-auto">
        <form method="POST" action="/configure">
            <?php foreach ($settings as $key => $value): ?>
                <div class="mb-3">
                    <label for="<?= $key; ?>" class="form-label"><?= ucfirst($key); ?></label>
                    <input type="text" class="form-control" id="<?= $key; ?>" name="<?= $key; ?>" value="<?= $value; ?>" required>
                </div>
            <?php endforeach; ?>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</div>
<script src="app_assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>