<?php
// Build absolute asset URL from config baseUrl regardless of subdir or protocol
$base = $site_config['baseUrl'] ?? ($GLOBALS['config']['baseUrl'] ?? '') ?? (isset($site_config['site']['baseURL']) ? $site_config['site']['baseURL'] : ($GLOBALS['config']['site']['baseURL'] ?? ''));
$asset = function($path) use ($base) {
    $path = ltrim($path, '/');
    return rtrim($base, '/') . '/' . $path;
};
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#0f172a">
    <meta name="description" content="Home Hardware PWA Application">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="mobile-web-app-capable" content="yes">
    <title>Home Hardware</title>
    
    <!-- PWA Meta Tags -->
    <link rel="manifest" href="<?php echo $asset('manifest.json'); ?>">
    <link rel="apple-touch-icon" href="<?php echo $asset('icons/icon-192.png'); ?>">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Home Hardware">
    
    <!-- Styles -->
<link rel="stylesheet" type="text/css" href="<?php echo $asset('app_assets/css/style.css'); ?>">
    
    <!-- PWA Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('<?php echo $asset('sw.js'); ?>')
                    .then(registration => {
                        console.log('ServiceWorker registration successful with scope: ', registration.scope);
                    })
                    .catch(error => {
                        console.log('ServiceWorker registration failed: ', error);
                    });
            });
        }
    </script>
    <link rel="icon" href="<?php echo $asset('favicon.ico'); ?>">
</head>
<body>

<script>
    //setTimeout(function(){
        //window.location.href = 'idle.php';
       // window.location.href = 'idleplaylist';
   // }, 120000);
</script>

<!--- Page container --->
<div class="page_container">