<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

/**
 * @var array $site_config
 */

// The config is already loaded in path_helper.php which is included by the controller
require __DIR__ . '/partials/head.php';
require __DIR__ . '/partials/head_image.php';
?>

<div class="flex-container">
    <!-- Row 1 -->
    <div>
        <a href="https://www.homehardware.ca/en/flyer">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_offers.svg'); ?>" alt="Special Offers" class="buttonicon">
            </div>
            <div class="buttontext">Flyers</div>
        </a>
    </div>

    <div>
        <a href="https://www.homehardware.ca/en/landing/hh-pro-contractor-services">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_prooffers.svg'); ?>" alt="PRO Offers" class="buttonicon">
            </div>
            <div class="buttontext">PRO Flyers</div>
        </a>
    </div>

    <div>
        <a href="<?php echo base_url('news'); ?>">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_latestnews.svg'); ?>" alt="Latest News" class="buttonicon">
            </div>
            <div class="buttontext">Store News</div>
        </a>
    </div>

    <div>
        <a href="https://<?php echo htmlspecialchars($site_config['chain_url'] ?? 'www.homehardware.ca'); ?>" target="_blank">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_website.svg'); ?>" alt="Our Website" class="buttonicon">
            </div>
            <div class="buttontext">Our Website</div>
        </a>
    </div>

    <!-- Row 2 -->
    <div>
        <a href="https://<?php echo htmlspecialchars($site_config['chain_url'] ?? 'www.homehardware.ca'); ?>/store-locator" target="_blank">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_storelocator.svg'); ?>" alt="Store Locator" class="buttonicon">
            </div>
            <div class="buttontext">Branch Locator</div>
        </a>
    </div>

    <div>
        <a href="<?php echo base_url('email?emailType=store'); ?>">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_inquiries.svg'); ?>" alt="Contact Us" class="buttonicon">
            </div>
            <div class="buttontext">Contact Us</div>
        </a>
    </div>

    <div>
        <a href="https://www.essexfreepress.com/news" target="_blank">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_localnews.svg'); ?>" alt="Local News" class="buttonicon">
            </div>
            <div class="buttontext">Local News</div>
        </a>
    </div>

    <div>
        <a href="https://www.accuweather.com/" target="_blank">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_weather.svg'); ?>" alt="Weather" class="buttonicon">
            </div>
            <div class="buttontext">Weather</div>
        </a>
    </div>

    <!-- Row 3 -->
    <div>
        <a href="<?php echo base_url('showvideo?video=socialmedia.mp4'); ?>">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_socials.svg'); ?>" alt="Social Media" class="buttonicon">
            </div>
            <div class="buttontext">Social Media</div>
        </a>
    </div>

    <div>
        <a href="<?php echo base_url('sponsors'); ?>">
            <div class="buttonbox">
                <img src="<?php echo asset_url('svg/btn_sponsors.svg'); ?>" alt="Our Sponsors" class="buttonicon">
            </div>
            <div class="buttontext">Our Sponsors</div>
        </a>
    </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
