<?php

// Update the schema of sponsor_content.db to match the expected structure
$dbPath = __DIR__ . '/sponsor_content.db';

try {
    // Connect to the database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if table exists
    $tableExists = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='sponsors'")->fetch();
    
    if (!$tableExists) {
        // Create the sponsors table with the required schema
        $db->exec("CREATE TABLE IF NOT EXISTS sponsors (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            contract TEXT,
            business_name TEXT,
            address_1 TEXT,
            address_2 TEXT,
            street TEXT,
            city TEXT,
            county TEXT,
            postal_code TEXT,
            country TEXT,
            phone TEXT,
            mobile TEXT,
            email TEXT,
            url TEXT,
            social TEXT,
            banner TEXT,
            button TEXT,
            mp4 TEXT,
            sort_order INTEGER DEFAULT 1,
            display_order INTEGER DEFAULT 0,
            is_active INTEGER DEFAULT 1,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        echo "Created sponsors table with all required columns.\n";
    } else {
        // Table exists, check and add any missing columns
        $columns = $db->query("PRAGMA table_info(sponsors)")->fetchAll(PDO::FETCH_COLUMN, 1);
        
        if (!in_array('display_order', $columns)) {
            $db->exec("ALTER TABLE sponsors ADD COLUMN display_order INTEGER DEFAULT 0");
            echo "Added display_order column to sponsors table.\n";
            
            // Copy sort_order values to display_order if sort_order exists
            if (in_array('sort_order', $columns)) {
                $db->exec("UPDATE sponsors SET display_order = sort_order");
                echo "Copied sort_order values to display_order.\n";
            }
        }
        
        if (!in_array('is_active', $columns)) {
            $db->exec("ALTER TABLE sponsors ADD COLUMN is_active INTEGER DEFAULT 1");
            echo "Added is_active column to sponsors table.\n";
        }
        
        if (!in_array('created_at', $columns)) {
            $db->exec("ALTER TABLE sponsors ADD COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
            echo "Added created_at column to sponsors table.\n";
        }
        
        if (!in_array('updated_at', $columns)) {
            $db->exec("ALTER TABLE sponsors ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
            echo "Added updated_at column to sponsors table.\n";
        }
    }
    
    echo "Sponsor content database schema is up to date.\n";
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage() . "\n");
}
