<?php

namespace Controllers;

use Exception;

class NewsController
{
    public Playlist $playlist;

    public function __construct()
    {
        $this->playlist = new Playlist();
    }

    public function showNews(): void
    {
        try {
            $fileName = 'public/app_assets/playlists/playlist.csv';
            // Check if file exists/is readable
            if (!$this->playlist->checkFile($fileName)) {
                $_SESSION['playlist'] = array();
            } else {
                $this->createNewsPlaylist($fileName);
            }
        } catch (Exception $e) {
            echo "Error creating News playlist: " . $e->getMessage();
            header('Location: /index');
            exit;
        }

        // If current playlist index is not set, set to 0
        if (!isset($_SESSION['current_playlist_index'])) {
            $_SESSION['current_playlist_index'] = 0;
        } elseif ($_SESSION['current_playlist_index'] > 0) {
            $_SESSION['current_playlist_index'] = 0;
        }

        require 'public/views/show_news.view.php';
    }

    public function createNewsPlaylist($fileName): void
    {
        try {
            $_SESSION['playlist'] = array(); // Reset the playlist array
            $this->playlist->createNewsPlaylist($fileName);
        } catch (Exception $e) {
            // Handle exception
        }
    }
}