<?php

$dbPath = __DIR__ . '/../sponsor_content.db';

try {
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Start transaction
    $db->beginTransaction();
    
    echo "Creating sponsors table...\n";
    
    // Drop existing table if it exists
    $db->exec("DROP TABLE IF EXISTS sponsors");
    
    // Create the table with all required columns
    $db->exec("CREATE TABLE sponsors (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        business_name TEXT,
        contract TEXT DEFAULT '',
        address_1 TEXT DEFAULT '',
        address_2 TEXT DEFAULT '',
        street TEXT DEFAULT '',
        city TEXT DEFAULT '',
        county TEXT DEFAULT '',
        postal_code TEXT DEFAULT '',
        country TEXT DEFAULT '',
        phone TEXT DEFAULT '',
        mobile TEXT DEFAULT '',
        email TEXT DEFAULT '',
        url TEXT DEFAULT '',
        social TEXT DEFAULT '',
        banner TEXT DEFAULT '',
        button TEXT,
        mp4 TEXT,
        sort_order INTEGER DEFAULT 0,
        is_active INTEGER DEFAULT 1,
        display_order INTEGER DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Commit the transaction
    $db->commit();
    
    echo "Sponsors table created successfully!\n";
    
    // Create a sample sponsor
    $db->exec("INSERT INTO sponsors (business_name, is_active) VALUES ('Sample Sponsor', 1)");
    echo "Added a sample sponsor.\n";
    
} catch (PDOException $e) {
    // Rollback the transaction in case of errors
    if (isset($db) && $db->inTransaction()) {
        $db->rollBack();
    }
    die("Error: " . $e->getMessage() . "\n");
}

// Run the check script to verify the table
include __DIR__ . '/check_sponsor_content_db.php';
