<?php

$dbPath = __DIR__ . '/../sponsor_content.db';

try {
    // Check if database file exists
    if (!file_exists($dbPath)) {
        die("Error: Database file not found at: $dbPath\n");
    }
    
    // Check if database is writable
    if (!is_writable($dbPath)) {
        die("Error: Database file is not writable: $dbPath\n");
    }
    
    // Try to connect to the database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Successfully connected to database: $dbPath\n";
    
    // Check if sponsors table exists
    $tableExists = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='sponsors'")->fetchColumn();
    
    if (!$tableExists) {
        die("Error: 'sponsors' table does not exist in the database.\n");
    }
    
    // Get table structure
    $stmt = $db->query("PRAGMA table_info(sponsors)");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\nTable 'sponsors' structure:\n";
    echo str_repeat("-", 50) . "\n";
    
    $columnNames = [];
    foreach ($columns as $column) {
        echo "- {$column['name']} ({$column['type']})\n";
        $columnNames[] = $column['name'];
    }
    
    echo "\nLooking for required columns...\n";
    $requiredColumns = ['id', 'business_name', 'is_active', 'display_order'];
    $missingColumns = [];
    
    foreach ($requiredColumns as $col) {
        if (!in_array($col, $columnNames)) {
            $missingColumns[] = $col;
            echo "- MISSING: $col\n";
        } else {
            echo "- FOUND: $col\n";
        }
    }
    
    if (!empty($missingColumns)) {
        echo "\nError: Missing required columns: " . implode(', ', $missingColumns) . "\n";
    } else {
        echo "\nAll required columns are present.\n";
    }
    
    // Try a sample query
    try {
        $testQuery = $db->query('SELECT id, business_name FROM sponsors LIMIT 1');
        $result = $testQuery->fetch(PDO::FETCH_ASSOC);
        echo "\nTest query successful. Found " . count($result) . " columns in result.\n";
    } catch (PDOException $e) {
        echo "\nTest query failed: " . $e->getMessage() . "\n";
    }
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage() . "\n");
}

echo "\nCheck complete.\n";
