<?php
// Database check script

echo "<h2>Database Connection and Permissions Check</h2>";

// Database path from your logs
$dbPath = 'H:/xampp/htdocs/HomeHardware_PWA/HomeHardware/htdocs/sponsor_content.db';
$dbDir = dirname($dbPath);

echo "<h3>1. File System Check</h3>";
echo "Checking database file: " . htmlspecialchars($dbPath) . "<br>";

// Check if file exists
if (file_exists($dbPath)) {
    echo "✅ Database file exists<br>";
    
    // Check file permissions
    $permissions = fileperms($dbPath);
    echo "File permissions: " . substr(sprintf('%o', $permissions), -4) . "<br>";
    
    // Check if file is readable
    echo is_readable($dbPath) ? "✅ File is readable<br>" : "❌ File is not readable<br>";
    
    // Check if file is writable
    echo is_writable($dbPath) ? "✅ File is writable<br>" : "❌ File is not writable<br>";
    
    // Check file size
    $fileSize = filesize($dbPath);
    echo "File size: " . number_format($fileSize) . " bytes<br>";
} else {
    echo "❌ Database file does not exist<br>";
    // Check if directory exists and is writable
    if (is_dir($dbDir)) {
        echo "Parent directory exists: " . htmlspecialchars($dbDir) . "<br>";
        echo is_writable($dbDir) ? "✅ Directory is writable<br>" : "❌ Directory is not writable<br>";
    } else {
        echo "❌ Parent directory does not exist: " . htmlspecialchars($dbDir) . "<br>";
    }
}

echo "<h3>2. Database Connection Test</h3>";
try {
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Successfully connected to the database<br>";
    
    // Get SQLite version
    $version = $db->query('SELECT sqlite_version()')->fetchColumn();
    echo "SQLite version: " . htmlspecialchars($version) . "<br>";
    
    // List all tables
    echo "<h3>3. Database Tables</h3>";
    $tables = $db->query("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
    
    if (count($tables) > 0) {
        echo "Found " . count($tables) . " tables:<br>";
        echo "<ul>";
        foreach ($tables as $table) {
            echo "<li><strong>" . htmlspecialchars($table) . "</strong>";
            
            // Show table structure
            try {
                $columns = $db->query("PRAGMA table_info(`$table`)")->fetchAll(PDO::FETCH_ASSOC);
                echo "<ul>";
                foreach ($columns as $col) {
                    echo "<li>" . htmlspecialchars($col['name']) . " (" . htmlspecialchars($col['type']) . ")";
                    if ($col['pk']) echo " [PRIMARY KEY]";
                    if ($col['notnull']) echo " [NOT NULL]";
                    if ($col['dflt_value'] !== null) echo " [DEFAULT: " . htmlspecialchars($col['dflt_value']) . "]";
                    echo "</li>";
                }
                
                // Show row count
                $count = $db->query("SELECT COUNT(*) FROM `$table`")->fetchColumn();
                echo "<li>Rows: " . number_format($count) . "</li>";
                
                echo "</ul>";
            } catch (Exception $e) {
                echo " - Error reading table structure: " . htmlspecialchars($e->getMessage());
            }
            echo "</li>";
        }
        echo "</ul>";
    } else {
        echo "No tables found in the database.<br>";
    }
    
} catch (PDOException $e) {
    echo "❌ Database connection failed: " . htmlspecialchars($e->getMessage()) . "<br>";
}

echo "<h3>4. Environment Information</h3>";
echo "PHP Version: " . phpversion() . "<br>";
echo "PDO SQLite Driver: " . (in_array('sqlite', PDO::getAvailableDrivers()) ? 'Enabled' : 'Not enabled') . "<br>";
?>
